///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabAdvancedDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND TCPLoopDelay_hWnd   = NULL;

    if(xMessage == WM_INITDIALOG)
    {
        char Temp[32];

        TCPLoopDelay_hWnd     = GetDlgItem(xHandle, IDC_TCPLOOPDELAY);

        LongCharEx(glTCPLoopDelay, Temp);
        Set_Text(TCPLoopDelay_hWnd, Temp);

        return TRUE;
    }

    if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            DWORD llTCPLoopDelay = Get_Long(TCPLoopDelay_hWnd);
            if(llTCPLoopDelay == 0 || llTCPLoopDelay > 65535)
            {
                MessageBox(xHandle, "You must enter a valid TCP loop delay. Between 1 and 60000.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            glTCPLoopDelay = llTCPLoopDelay;

            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

